USE [ProSolutionReports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [vOG_2526_Course]
AS
------------------------------------------------
--Course Import Template for OneGrade VA.  Update each ac yr to bring in current year courses.
------------------------------------------------

SELECT 
	T.AcademicYearID,
	T.Code,
	CAST([Off].Name AS VARCHAR(150)) AS Description,
	NULL AS UDFS1, NULL AS UDFS2, NULL AS UDFS3, NULL AS UDFS4
FROM
	(
		--This will return the key enrolment records and avoid duplicates
		SELECT 
			Max(vOG_CourseCode.OfferingID) AS MaxOfferingID,
			O.AcademicYearID AS AcademicYearID,					--*UniqueKey
			vOG_CourseCode.CourseCode AS Code					--*UniqueKey
		FROM
			vOG_CourseCode WITH (NOLOCK)
				INNER JOIN ProSolution.dbo.Offering O WITH (NOLOCK)
				ON vOG_CourseCode.OfferingID = O.OfferingID
				AND O.AcademicYearID = '25/26'
		GROUP BY
			O.AcademicYearID, vOG_CourseCode.CourseCode
	) T

--ensure that we join on T.MinStudentDetailID
INNER JOIN ProSolution.dbo.Offering [Off] WITH (NOLOCK)
	ON T.MaxOfferingID = [Off].OfferingID

GO
